function log_error(msg) {
    console.log("ERROR: " + msg);
    $("#error-msg").html(msg);
}

function log_debug(msg) {
    console.log("DEBUG: " + msg);
}

function redirect_to(url) {
    if (url === undefined) {
        url = "/";
    }
    log_debug("Redirect to: " + url);
    document.location = url;
}

function walk(root, path) {
    var error_url = "/";

    var node = root;
    for (var e = 0; e < path.length; e++) {
        if (node !== undefined && node["_error"] !== undefined) {
            error_url = node["_error"];
        }
        var path_element = path[e];
        log_debug("Looking for path element: " + path_element);
        node = node[path_element];
        if (node === undefined) {
            log_error("Failed to walk through path [" + path.join(", ") + "], element is missing: " + path_element);
            if (error_url !== undefined) {
                redirect_to(error_url);
            }
            return undefined;
        }
    }
    return node;
}

function get_parameter_by_name(name, url) {
    if (!url) {
        url = window.location.href;
    }
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)");
    var results = regex.exec(url);
    if (!results)
        return undefined;
    if (!results[2])
        return undefined;
    return decodeURIComponent(results[2].replace(/\+/g, " "));
}

$(document).ready(function() {
    var id = get_parameter_by_name("id");
    if (id === undefined) {
        log_error("Missing/Invalid parameter: id");
        return;
    }
    var language = get_parameter_by_name("lang");
    if (language === undefined) {
        log_error("Missing/Invalid parameter: lang");
        return;
    }
    var version = get_parameter_by_name("v");
    if (version === undefined) {
        log_error("Missing/Invalid parameter: v");
        return;
    }
    var pdt = get_parameter_by_name("pdt");
    if (pdt === undefined) {
        pdt = "SNS";
    }
    if (version.substr(0, 3) == "9.1" || version.substr(0, 2) == "91") {
        version = "9.1";
    } else {
        version = version.substr(0, 1);
    }

    log_debug("Ready: version=" + version + " language=" + language + " id=" + id + " produit=" + pdt);
    $(document).ajaxError(function(event, jqxhr, settings, thrownError) {
        log_error("No translations for version " + version + ": " + thrownError);
	redirect_to();
    });
    $.getJSON("../"+pdt + "/v" + version + "/translations-" + version + ".json", function(translations) {
        log_debug("Translations loaded.");

        var url = walk(translations, [language, id]);
        if (url === undefined && language != 'en') {
            log_debug("No translation for the requested (version, language, ID) combination: (" + version + ", " + language + ", " + id + ") Searching for EN.");
            var url = walk(translations, ['en', id]);
        }
        if (url === undefined && language == 'en') {
            log_error("No translation for the requested (version, language, ID) combination: (" + version + ", " + language + ", " + id + ")");
            return;
        }
        redirect_to(url);
    });
});